function [ value ] = sval( d,delta,c,t,l )
%Eval S^r_d(\delta) spline is c on normalized B-spline at point t.
%   d is the degree polynomials.  delta is the already extended knot
%   sequence.  c are the row coefficients of our spline on the S^r_d
%   normalized basis.  t is the point in question and l is findinterval
%   output of t relative to delta. Value is computed by DeCastle'jeau.

M = zeros(d+1,d+1); %For storing the iterated coefficients
M(1,:) = c(1,l-d:l);

%Schumaker wrote for c^{j+1}_{i} where here I'm writing 
%for (M_ij) = c^j_(i+l-d-1) because my j:2->d+1, is j_schu = j-1, 
%and my i ranges over matrix index i:j->d+1 whereas i_schu:l-d+j_shu->l.
%as before subtract across at either ends to get offset.

for j=2:d+1 %Rows of Schumaker De'Castlejeau
    for i=j:d+1 %Columns of Shumaker De'Castlejeau
        length = delta(1,(i+l-d-1)+d-(j-1)+1)-delta(1,(i+l-d-1));
        if length == 0
            M(j,i) = 0;
        else
            M(j,i) = M(j-1,i)*(t-delta(1,(i+l-d-1)))/length + M(j-1,i-1)*(delta(1,(i+l-d-1)+d-(j-1)+1)-t)/length;
        end
    end
end

value = M(d+1,d+1); %Output value of spline
end

